define(function (require) {
	'use strict';

	var View = require('app/base/view');
	var JST = window.JST;
	var LivesView = require('app/views/lives_left');

	return View.extend({
		template: JST['assets/tpl/client/after_question.html'],
		initialize: function (data) {
			data = data || {};

			this.game = data.game;
		},
		render: function () {
			var user = this.game.getMeUser();
			var question = this.game.getCurrentQuestion();
			var answer = user.getAnswer(question.get('id'));
			var isCorrect = answer.isCorrect;

			this.$el.html(this.template({
				isCorrect: isCorrect,
				question: question
			}));

			var lives = new LivesView({
				el: this.$el.find('.lives-section'),
				model: this.game
			}).render();

			return this;
		}
	});
});